/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropTabPanel;
import filenet.vw.toolkit.runtime.property.images.VWImageLoader;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.runtime.summary.VWSummaryInfoTable;
import filenet.vw.toolkit.runtime.summary.VWSummaryInfoTableModel;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;

public class VWStepGeneralPanel
extends VWStepPropTabPanel {
    private JPanel m_commonInfoPanel = new JPanel();
    private JPanel m_stepViewPanel = new JPanel();
    private JPanel m_participantViewPanel = new JPanel();
    private JPanel m_privilegePanel = new JPanel();
    private JTextField m_receivedUI = new JTextField();
    private Date m_receivedStep = null;
    private Date m_receivedParticipant = null;
    private JTextField m_deadlineUI = new JTextField();
    private Date m_deadlineStep = null;
    private Date m_deadlineParticipant = null;
    private JTextField m_statusUI = new JTextField();
    private JLabel m_statusIcon = new JLabel();
    private int m_statusStep = 0;
    private int m_statusParticipant = 0;
    private Date m_statusStepDate = null;
    private Date m_statusParticipantDate = null;
    private VWToolbarBorder m_stepProcessorBorder = null;
    private VWToolbarBorder m_privBorder = null;
    private JTextField m_selResponseUI = new JTextField();
    private String m_selResponse = null;
    private JTextArea m_commentsUI = new JTextArea();
    private String m_comments = null;
    private VWSummaryInfoTable m_summaryInfoTable = null;
    private VWSummaryInfoTableModel m_summaryInfoTableModel = null;
    private boolean m_bUseCustomURL = false;
    private JTextField m_customURLUI = new JTextField();
    private String m_customURL = null;
    private JCheckBox m_allowReassignUI = new JCheckBox();
    private ActionListener m_allowReassignUIActionListener = null;
    private boolean m_allowReassign = false;
    private JCheckBox m_allowViewStatusUI = new JCheckBox();
    private ActionListener m_allowViewStatusUIActionListener = null;
    private boolean m_allowViewStatus = false;
    private JCheckBox m_allowViewHistoryUI = new JCheckBox();
    private ActionListener m_allowViewHistoryUIActionListener = null;
    private boolean m_allowViewHistory = false;
    private DateFormat m_dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2);

    public VWStepGeneralPanel(Frame parentFrame, VWBaseStepPropPanel propPanel) {
        super(parentFrame, propPanel);
        this.m_type = 1;
    }

    protected void initData() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        this.initCommonInfoPanelData();
        this.initStepViewPanelData();
        this.initParticipantViewPanelData();
        this.initPrivilegePanelData();
    }

    protected void setupLayout() {
        this.setupCommonInfoPanel();
        this.setupStepViewPanel();
        this.setupParticipantViewPanel();
        this.setupPrivilegePanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_commonInfoPanel, "First");
        this.add((Component)this.m_stepViewPanel, "Center");
        this.add((Component)this.m_privilegePanel, "Last");
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
    }

    protected void updateDisplay() {
        this.updateCommonInfoPanel();
        this.updateStepViewPanel();
        this.updateParticipantViewPanel();
        this.updatePrivilegePanel();
        if (this.m_selectionChanged == 2) {
            if (this.m_bStepView) {
                this.remove(this.m_participantViewPanel);
                this.m_participantViewPanel.setVisible(false);
                this.add((Component)this.m_stepViewPanel, "Center");
                this.m_stepViewPanel.setVisible(true);
                this.m_stepViewPanel.revalidate();
            } else {
                this.remove(this.m_stepViewPanel);
                this.m_stepViewPanel.setVisible(false);
                this.add((Component)this.m_participantViewPanel, "Center");
                this.m_participantViewPanel.setVisible(true);
            }
        }
    }

    protected void setupCommonInfoPanel() {
        GridBagConstraints c = new GridBagConstraints();
        Insets noInsets = new Insets(0, 0, 0, 0);
        Insets insets = new Insets(0, 6, 0, 0);
        this.updateCommonInfoPanel();
        this.m_commonInfoPanel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 23;
        this.m_commonInfoPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_received)), c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.insets = insets;
        c.fill = 2;
        this.m_receivedUI.setEditable(false);
        this.m_receivedUI.setBorder(null);
        this.m_commonInfoPanel.add((Component)this.m_receivedUI, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = noInsets;
        c.fill = 0;
        this.m_commonInfoPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_status)), c);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = insets;
        this.m_commonInfoPanel.add((Component)this.m_statusIcon, c);
        c.gridx = 2;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 2, 0, 0);
        this.m_statusUI.setEditable(false);
        this.m_statusUI.setBorder(null);
        this.m_commonInfoPanel.add((Component)this.m_statusUI, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = noInsets;
        c.fill = 0;
        this.m_commonInfoPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_deadline)), c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = insets;
        this.m_deadlineUI.setEditable(false);
        this.m_deadlineUI.setBorder(null);
        this.m_commonInfoPanel.add((Component)this.m_deadlineUI, c);
    }

    void updateCommonInfoPanel() {
        if (this.m_step == null || this.m_step.isLaunchStep()) {
            this.m_receivedUI.setText("");
            this.m_deadlineUI.setText("");
            this.m_statusUI.setText("");
            this.m_statusIcon.setIcon(null);
        } else {
            Date date;
            int status;
            if (this.m_bStepView) {
                if (this.m_receivedStep != null) {
                    this.m_receivedUI.setText(this.m_dateTimeFormatter.format(this.m_receivedStep));
                } else {
                    this.m_receivedUI.setText("");
                }
                if (this.m_deadlineStep != null) {
                    this.m_deadlineUI.setText(this.m_dateTimeFormatter.format(this.m_deadlineStep));
                } else {
                    this.m_deadlineUI.setText("");
                }
            } else {
                if (this.m_receivedParticipant != null) {
                    this.m_receivedUI.setText(this.m_dateTimeFormatter.format(this.m_receivedParticipant));
                } else {
                    this.m_receivedUI.setText("");
                }
                if (this.m_deadlineParticipant != null) {
                    this.m_deadlineUI.setText(this.m_dateTimeFormatter.format(this.m_deadlineParticipant));
                } else {
                    this.m_deadlineUI.setText("");
                }
            }
            if (this.m_bStepView) {
                status = this.m_statusStep;
                date = this.m_statusStepDate;
            } else {
                status = this.m_statusParticipant;
                date = this.m_statusParticipantDate;
            }
            if (date != null) {
                this.m_statusUI.setText(this.m_dateTimeFormatter.format(date));
            } else {
                this.m_statusUI.setText("");
            }
            ImageIcon icon = VWImageLoader.createStatusIcon(status);
            this.m_statusIcon.setIcon(icon);
            switch (status) {
                case 1: {
                    this.m_statusUI.setText(VWResource.s_inProgress);
                    break;
                }
                case 9: {
                    this.m_statusUI.setText(VWResource.s_overdue);
                    break;
                }
                case 10: {
                    this.m_statusUI.setText(VWResource.s_reminded);
                    break;
                }
                case 12: {
                    this.m_statusUI.setText(VWResource.s_exception);
                    break;
                }
                case 13: {
                    this.m_statusUI.setText(VWResource.s_pastException);
                }
            }
        }
    }

    protected void setupStepViewPanel() {
        this.m_stepViewPanel.setLayout(new BorderLayout());
        this.m_stepViewPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_stepStatus)), "First");
        this.m_summaryInfoTable = new VWSummaryInfoTable(this.m_parentFrame, this.m_summaryInfoTableModel){

            protected void initColumns() {
                TableColumn stepColumn = this.m_columnModel.getColumn(1);
                TableColumn occurrenceColumn = this.m_columnModel.getColumn(2);
                TableColumn receivedColumn = this.m_columnModel.getColumn(4);
                this.m_columnModel.removeColumn(stepColumn);
                this.m_columnModel.removeColumn(occurrenceColumn);
                this.m_columnModel.removeColumn(receivedColumn);
            }
        };
        this.m_stepViewPanel.add((Component)new JScrollPane(this.m_summaryInfoTable), "Center");
    }

    protected void updateStepViewPanel() {
        this.m_summaryInfoTableModel.fireTableDataChanged();
    }

    protected void setupParticipantViewPanel() {
        GridBagConstraints c = new GridBagConstraints();
        this.m_participantViewPanel.setLayout(new GridBagLayout());
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        this.m_participantViewPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_response)), c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 6, 0, 0);
        this.m_selResponseUI.setText(this.m_selResponse);
        this.m_selResponseUI.setEditable(false);
        this.m_selResponseUI.setBackground(this.getBackground());
        this.m_participantViewPanel.add((Component)this.m_selResponseUI, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_participantViewPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_comments)), c);
        c.gridy = -1;
        c.weighty = 1.0;
        c.insets = new Insets(0, 6, 0, 0);
        this.m_commentsUI.setText(this.m_comments);
        this.m_commentsUI.setWrapStyleWord(true);
        this.m_commentsUI.setLineWrap(true);
        this.m_commentsUI.setEditable(false);
        this.m_participantViewPanel.add((Component)new JScrollPane(this.m_commentsUI), c);
    }

    protected void updateParticipantViewPanel() {
        if (this.m_step == null || this.m_step.isLaunchStep()) {
            this.m_selResponseUI.setText("");
            this.m_commentsUI.setText("");
        } else {
            this.m_selResponseUI.setText(this.m_selResponse);
            this.m_commentsUI.setText(this.m_comments);
        }
    }

    protected void setupPrivilegePanel() {
        JPanel panel = null;
        GridBagConstraints c = new GridBagConstraints();
        this.m_privilegePanel.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 23;
        c.gridwidth = 0;
        c.fill = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        VWToolbarBorder m_stepProcessorBorder = new VWToolbarBorder(VWResource.s_stepProcessor, 0);
        panel = m_stepProcessorBorder.getClientPanel();
        panel.setLayout(new BorderLayout());
        if (this.m_customURL != null) {
            this.m_customURLUI.setText(this.m_customURL);
        } else {
            this.m_customURLUI.setText("");
        }
        this.m_customURLUI.setEditable(false);
        panel.add((Component)this.m_customURLUI, "Center");
        this.m_privilegePanel.add((Component)m_stepProcessorBorder, c);
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_privBorder = new VWToolbarBorder(VWResource.s_participantPrivileges, 0);
        panel = this.m_privBorder.getClientPanel();
        panel.setLayout(new GridLayout(1, 2));
        this.m_allowReassignUI.setText(VWResource.s_reassign);
        this.m_allowReassignUI.setSelected(this.m_allowReassign);
        this.m_allowReassignUIActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VWStepGeneralPanel.this.m_allowReassignUI.setSelected(VWStepGeneralPanel.this.m_allowReassign);
            }
        };
        this.m_allowReassignUI.addActionListener(this.m_allowReassignUIActionListener);
        panel.add(this.m_allowReassignUI);
        this.m_allowViewStatusUI.setText(VWResource.s_viewStatus);
        this.m_allowViewStatusUI.setSelected(this.m_allowViewStatus);
        this.m_allowViewStatusUIActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VWStepGeneralPanel.this.m_allowViewStatusUI.setSelected(VWStepGeneralPanel.this.m_allowViewStatus);
            }
        };
        this.m_allowViewStatusUI.addActionListener(this.m_allowViewStatusUIActionListener);
        panel.add(this.m_allowViewStatusUI);
        this.m_allowViewHistoryUI.setText(VWResource.s_viewHistory);
        this.m_allowViewHistoryUI.setSelected(this.m_allowViewHistory);
        this.m_allowViewHistoryUIActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VWStepGeneralPanel.this.m_allowViewHistoryUI.setSelected(VWStepGeneralPanel.this.m_allowViewHistory);
            }
        };
        this.m_allowViewHistoryUI.addActionListener(this.m_allowViewHistoryUIActionListener);
        panel.add(this.m_allowViewHistoryUI);
        this.m_privilegePanel.add((Component)this.m_privBorder, c);
    }

    protected void updatePrivilegePanel() {
        if (this.m_selectionChanged != 4 && this.m_selectionChanged != 5) {
            return;
        }
        if (this.m_step == null || this.m_step.isLaunchStep()) {
            this.m_customURLUI.setText("");
            this.m_allowReassignUI.setSelected(false);
            this.m_allowReassignUI.setEnabled(false);
            this.m_allowViewStatusUI.setSelected(false);
            this.m_allowViewStatusUI.setEnabled(false);
            this.m_allowViewHistoryUI.setSelected(false);
            this.m_allowViewHistoryUI.setEnabled(false);
        } else {
            this.m_allowReassignUI.setEnabled(true);
            this.m_allowViewStatusUI.setEnabled(true);
            this.m_allowViewHistoryUI.setEnabled(true);
            this.m_customURLUI.setText(this.m_customURL);
            this.m_allowReassignUI.setSelected(this.m_allowReassign);
            this.m_allowViewStatusUI.setSelected(this.m_allowViewStatus);
            this.m_allowViewHistoryUI.setSelected(this.m_allowViewHistory);
        }
    }

    protected void initCommonInfoPanelData() {
        if (this.m_stepOccurrence != null) {
            this.m_receivedStep = this.m_stepOccurrence.getDateReceived();
            this.m_statusStep = this.m_stepOccurrence.getStatus();
            this.m_deadlineStep = this.m_stepOccurrence.getDeadline();
            this.m_statusStepDate = this.m_stepOccurrence.getCompletionDate();
        } else {
            this.m_receivedStep = null;
            this.m_statusStep = 0;
            this.m_deadlineStep = null;
            this.m_statusStepDate = null;
        }
        if (this.m_participant != null) {
            this.m_receivedParticipant = this.m_participant.getDateReceived();
            this.m_deadlineParticipant = this.m_participant.getDeadline();
            this.m_statusParticipant = this.m_participant.getStatus();
            this.m_statusParticipantDate = this.m_participant.getCompletionDate();
        } else {
            this.m_receivedParticipant = null;
            this.m_deadlineParticipant = null;
            this.m_statusParticipant = 0;
            this.m_statusParticipantDate = null;
        }
    }

    protected void initStepViewPanelData() {
        if (this.m_selectionChanged < 3) {
            return;
        }
        Vector<VWTrkStepOccurrence> selected = new Vector<VWTrkStepOccurrence>();
        selected.addElement(this.m_stepOccurrence);
        if (this.m_summaryInfoTableModel == null) {
            this.m_summaryInfoTableModel = new VWSummaryInfoTableModel(selected);
        } else {
            this.m_summaryInfoTableModel.setSelected(selected);
        }
    }

    protected void initParticipantViewPanelData() {
        if (this.m_participant != null) {
            this.m_selResponse = this.m_participant.getParticipantHistory().getResponse();
            if (this.m_selResponse == null) {
                this.m_selResponse = "";
            }
            this.m_comments = this.m_participant.getParticipantHistory().getComments();
            if (this.m_comments == null) {
                this.m_comments = "";
            }
        } else {
            this.m_selResponse = "";
            this.m_comments = "";
        }
    }

    protected void initPrivilegePanelData() {
        if (this.m_selectionChanged != 4 && this.m_selectionChanged != 5) {
            return;
        }
        if (this.m_step == null || this.m_step.isLaunchStep()) {
            this.m_customURL = "";
            this.m_allowReassign = false;
            this.m_allowViewStatus = false;
            this.m_allowViewHistory = false;
        } else {
            VWStepDefinition stepDefinition = this.m_step.getStepDefinition();
            VWStepProcessorInfo stepProcessor = null;
            if (stepDefinition.getRequestedInterface() != null) {
                stepProcessor = this.m_step.getStepProcessor();
            }
            this.m_customURL = stepProcessor != null ? stepProcessor.getName() : "";
            this.m_allowReassign = stepDefinition.getCanReassign();
            this.m_allowViewStatus = stepDefinition.getCanViewStatus();
            this.m_allowViewHistory = stepDefinition.getCanViewHistory();
        }
    }

    public void removeReferences() {
        super.removeReferences();
        if (this.m_commonInfoPanel != null) {
            this.m_commonInfoPanel.removeAll();
            this.m_commonInfoPanel = null;
        }
        if (this.m_stepViewPanel != null) {
            this.m_stepViewPanel.removeAll();
            this.m_stepViewPanel = null;
        }
        if (this.m_participantViewPanel != null) {
            this.m_participantViewPanel.removeAll();
            this.m_participantViewPanel = null;
        }
        if (this.m_privilegePanel != null) {
            this.m_privilegePanel.removeAll();
            this.m_privilegePanel = null;
        }
        if (this.m_stepProcessorBorder != null) {
            this.m_stepProcessorBorder.removeReferences();
            this.m_stepProcessorBorder = null;
        }
        if (this.m_privBorder != null) {
            this.m_privBorder.removeReferences();
            this.m_privBorder = null;
        }
        this.m_receivedUI = null;
        this.m_receivedStep = null;
        this.m_receivedParticipant = null;
        this.m_deadlineUI = null;
        this.m_deadlineStep = null;
        this.m_deadlineParticipant = null;
        this.m_statusUI = null;
        this.m_statusIcon = null;
        this.m_statusStepDate = null;
        this.m_statusParticipantDate = null;
        this.m_selResponseUI = new JTextField();
        this.m_selResponse = null;
        this.m_commentsUI = null;
        this.m_comments = null;
        if (this.m_summaryInfoTable != null) {
            this.m_summaryInfoTable.removeReferences();
            this.m_summaryInfoTable = null;
        }
        if (this.m_summaryInfoTableModel != null) {
            this.m_summaryInfoTableModel.removeReferences();
            this.m_summaryInfoTableModel = null;
        }
        this.m_customURLUI = null;
        this.m_customURL = null;
        if (this.m_allowReassignUI != null) {
            this.m_allowReassignUI.removeActionListener(this.m_allowReassignUIActionListener);
            this.m_allowReassignUI = null;
        }
        if (this.m_allowViewStatusUI != null) {
            this.m_allowViewStatusUI.removeActionListener(this.m_allowViewStatusUIActionListener);
            this.m_allowViewStatusUI = null;
        }
        if (this.m_allowViewHistoryUI != null) {
            this.m_allowViewHistoryUI.removeActionListener(this.m_allowViewHistoryUIActionListener);
            this.m_allowViewHistoryUI = null;
        }
        this.removeAll();
    }
}

